/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay;

import java.util.List;
import java.util.Vector;

public final class Scope {
    char[] levels = new char[]{' ', ' ', '.', '.', 'o', 'o', 'O', 'O', '@', '@'};
    double[] scopes;
    int delay;
    private static final double FALLOFF = 2.0;
    public EventDispatcher dispatcher;
    private List queue = new Vector();

    public Scope(int channels, int delay) {
        this.delay = delay;
        this.scopes = new double[channels];
        this.dispatcher = new EventDispatcher();
        new Thread(this.dispatcher).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void nextInternal() {
        int n = 0;
        while (n < this.scopes.length) {
            double[] dArray = this.scopes;
            // MONITORENTER : this.scopes
            int n2 = n;
            this.scopes[n2] = this.scopes[n2] - 2.0;
            if (this.scopes[n] < 0.0) {
                this.scopes[n] = 0.0;
            }
            // MONITOREXIT : dArray
            ++n;
        }
    }

    public void next() {
        Event e = new Event();
        e.type = 2;
        e.time = System.currentTimeMillis() + (long)this.delay;
        this.queue.add(e);
    }

    private void pokeInternal(int channel) {
        double[] dArray = this.scopes;
        synchronized (this.scopes) {
            this.scopes[channel] = this.levels.length - 1;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void poke(int channel) {
        Event e = new Event();
        e.type = 1;
        e.channel = channel;
        e.time = System.currentTimeMillis() + (long)this.delay;
        this.queue.add(e);
    }

    public char getChannel(int channel) {
        double[] dArray = this.scopes;
        synchronized (this.scopes) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.levels[(int)this.scopes[channel]];
        }
    }

    public String getAllChannels() {
        StringBuffer sb = new StringBuffer();
        int n = 0;
        while (n < this.scopes.length) {
            sb.append(this.getChannel(n));
            ++n;
        }
        return sb.toString();
    }

    public void stop() {
    }

    private static class Event {
        public static final int POKE = 1;
        public static final int NEXT = 2;
        public int type;
        public long time;
        public int channel;

        Event() {
        }

        public String toString() {
            return String.valueOf(this.type) + " " + this.time + " " + this.channel;
        }
    }

    private class EventDispatcher
    implements Runnable {
        public boolean stop = false;

        EventDispatcher() {
        }

        public void run() {
            block2: while (!this.stop) {
                while (true) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (Scope.this.queue.size() == 0) continue;
                    Event e = (Event)Scope.this.queue.get(0);
                    if (e.time > System.currentTimeMillis()) continue block2;
                    Scope.this.queue.remove(0);
                    if (e.type == 1) {
                        Scope.this.pokeInternal(e.channel);
                        continue;
                    }
                    if (e.type != 2) continue;
                    Scope.this.nextInternal();
                }
            }
        }
    }
}

